/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#include <time.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_db.h"
#include "udm_xmalloc.h"
#include "udm_utils.h"
#include "udm_agent.h"
#include "udm_word.h"
#include "udm_crossword.h"
#include "udm_sdp.h"
#include "udm_doc.h"
#include "udm_vars.h"

__INDLIB__ UDM_AGENT * UdmAgentInit(UDM_AGENT *result,UDM_ENV * Env, int handle){

	if(!result){
		result=(UDM_AGENT*)malloc(sizeof(UDM_AGENT));
		bzero(result,sizeof(*result));
		result->freeme=1;
	}else{
		bzero(result,sizeof(*result));
	}
	time(&result->start_time);
	result->Conf=Env;
	result->handle=handle; /* Handle is used in multi-threaded version */
	result->LangMap = (UDM_LANGMAP*)malloc(sizeof(UDM_LANGMAP));
	return(result);
}
__INDLIB__ void UdmAgentFree(UDM_AGENT *Indexer){
	if(!Indexer)return;
	UDM_FREE(Indexer->LangMap);
	if(Indexer->freeme)free(Indexer);
}


__INDLIB__ void UdmAgentSetAction(UDM_AGENT *Indexer,int action){
	Indexer->flags=action;
}

